/*
 * Decompiled with CFR 0.152.
 */
package psx;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Application;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import psx.PsxLoader;
import psyq.SigApplier;

public class PsxAnalyzer
extends AbstractAnalyzer {
    private Map<String, SigApplier> appliers;
    public static boolean onlyFirst = true;
    public static float minEntropy = 3.0f;
    private String manualVer = "4.7";
    private final String FIRST_OPTION = "Only first match";
    private final String MIN_ENTROPY = "Minimal signature entropy";
    private final String MANUAL_VER_OPTION = "PsyQ Version if not found";

    public static boolean isPsxLoader(Program program) {
        return program.getExecutableFormat().equalsIgnoreCase("PSX Executables Loader");
    }

    public PsxAnalyzer() {
        super("PsyQ Signatures", "PSX signatures applier", AnalyzerType.INSTRUCTION_ANALYZER);
        this.setSupportsOneTimeAnalysis();
        this.appliers = new HashMap<String, SigApplier>();
    }

    public boolean getDefaultEnablement(Program program) {
        return PsxAnalyzer.isPsxLoader(program);
    }

    public boolean canAnalyze(Program program) {
        return PsxAnalyzer.isPsxLoader(program);
    }

    public void registerOptions(Options options, Program program) {
        options.registerOption("Only first match", (Object)onlyFirst, null, "To increase signatures applying time set this option CHECKED. Applies only first entry!");
        options.registerOption("Minimal signature entropy", (Object)Float.valueOf(minEntropy), null, "To reduce false positive signatures applying set this value >= 3.0!");
        options.registerOption("PsyQ Version if not found", (Object)this.manualVer, null, "Use this version number if not found in the binary.");
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
        onlyFirst = options.getBoolean("Only first match", onlyFirst);
        minEntropy = options.getFloat("Minimal signature entropy", minEntropy);
        this.manualVer = options.getString("PsyQ Version if not found", this.manualVer);
        this.appliers = new HashMap<String, SigApplier>();
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        try {
            String psyqVersion = PsxLoader.getProgramPsyqVersion(program);
            AddressRangeIterator i = set.getAddressRanges();
            while (i.hasNext()) {
                AddressRange next = (AddressRange)i.next();
                if (psyqVersion.isEmpty() && !this.manualVer.isEmpty()) {
                    psyqVersion = this.manualVer.replace(".", "");
                    PsxLoader.setProgramPsyqVersion(program, psyqVersion);
                }
                this.applyPsyqSignaturesByVersion(psyqVersion, program, next.getMinAddress(), next.getMaxAddress(), monitor, log);
            }
            monitor.setMessage("Applying PsyQ functions and data types...");
            monitor.clearCanceled();
            PsxLoader.loadPsyqGdt(program, set);
            monitor.setMessage("Applying PsyQ functions and data types done.");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.appendException((Throwable)e);
            return false;
        }
        return true;
    }

    private void applyPsyqSignaturesByVersion(String version, Program program, Address startAddr, Address endAddr, TaskMonitor monitor, MessageLog log) throws IOException {
        File[] files;
        File patchesFile = Application.getModuleDataFile((String)"psyq/patches.json").getFile(false);
        String psyDir = String.format("psyq/%s", version);
        File verDir = Application.getModuleDataSubDirectory((String)psyDir).getFile(false);
        for (File file : files = verDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json") && !name.equals("patches.json");
            }
        })) {
            SigApplier sig;
            String fileName = file.getName();
            if (this.appliers.containsKey(fileName)) {
                sig = this.appliers.get(fileName);
            } else {
                sig = new SigApplier(program.getName(), file.getAbsolutePath(), patchesFile.getAbsolutePath(), onlyFirst, minEntropy, monitor);
                this.appliers.put(fileName, sig);
            }
            sig.applySignatures(program, startAddr, endAddr, monitor, log);
        }
    }
}

