/*
 * Decompiled with CFR 0.152.
 */
package psx;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.util.List;
import psx.OverlayManager;
import psx.PsxAnalyzer;
import psx.debug.DebuggerProvider;

@PluginInfo(status=PluginStatus.STABLE, packageName="Miscellaneous", category="Common", shortDescription="This plugin creates/imports overlayed binaries for PSX.", description="This plugin gives an ability to create/import binaries into an overlayed blocks for PSX.", servicesRequired={GoToService.class})
public class PsxPlugin
extends ProgramPlugin {
    private DebuggerProvider dbgProvider;
    private OverlayManagerProvider omProvider;

    public PsxPlugin(PluginTool tool) {
        super(tool, true, false);
    }

    public void programActivated(Program program) {
        super.programActivated(program);
        if (PsxAnalyzer.isPsxLoader(program)) {
            this.createOmAction();
            this.createDbgAction();
            PsxPlugin.gotoMain(this.getTool(), program);
        }
    }

    protected void dispose() {
        if (this.dbgProvider == null) {
            return;
        }
        this.dbgProvider.close();
    }

    private static void gotoMain(PluginTool tool, Program program) {
        SymbolTable st = program.getSymbolTable();
        List mainSym = st.getGlobalSymbols("main");
        if (mainSym.size() > 0) {
            PsxPlugin.gotoPc(tool, program, "default", ((Symbol)mainSym.get(0)).getAddress().getOffset());
        }
    }

    public static void gotoPc(PluginTool tool, Program program, String addrSpace, long pcAddr) {
        GoToService gotoService = (GoToService)tool.getService(GoToService.class);
        AddressFactory af = program.getAddressFactory();
        AddressSpace as = af.getAddressSpace(addrSpace);
        if (as == null) {
            as = af.getDefaultAddressSpace();
        }
        if (gotoService != null) {
            Address addr = as.getAddress(pcAddr);
            gotoService.goTo(addr);
        }
    }

    private void createOmAction() {
        DockingAction openOverlayManagerAction = new DockingAction("PsxOverlayManager", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (PsxPlugin.this.omProvider != null) {
                    PsxPlugin.this.omProvider.close();
                }
                PsxPlugin.this.omProvider = new OverlayManagerProvider(PsxPlugin.this.currentProgram);
                PsxPlugin.this.omProvider.showDialog(PsxPlugin.this.getTool());
            }
        };
        openOverlayManagerAction.setMenuBarData(new MenuData(new String[]{"&Tools", "PSX Overlay Manager..."}, "Psx"));
        this.tool.addAction((DockingActionIf)openOverlayManagerAction);
    }

    private void createDbgAction() {
        DockingAction createDebuggerAction = new DockingAction("PsxDebugger", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (PsxPlugin.this.dbgProvider == null) {
                    PsxPlugin.this.dbgProvider = new DebuggerProvider(PsxPlugin.this.getTool(), this.getName(), PsxPlugin.this.currentProgram);
                }
                if (!PsxPlugin.this.dbgProvider.isVisible()) {
                    PsxPlugin.this.dbgProvider.setVisible(true);
                }
                PsxPlugin.this.dbgProvider.toFront();
            }
        };
        createDebuggerAction.setMenuBarData(new MenuData(new String[]{"&Tools", "PSX Debugger..."}, "Psx"));
        this.tool.addAction((DockingActionIf)createDebuggerAction);
    }

    private static class OverlayManagerProvider
    extends DialogComponentProvider {
        public OverlayManagerProvider(Program program) {
            super("New Overlay from Data", true, true, true, false);
            this.addWorkPanel(new OverlayManager(program, this));
        }

        public void showDialog(PluginTool tool) {
            tool.showDialog((DialogComponentProvider)this);
        }
    }
}

