/*
 * Decompiled with CFR 0.152.
 */
package psx.debug;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import psx.debug.DebuggerCmd;
import psx.debug.DebuggerGprRegister;

public class DebuggerCore {
    public static final int DEBUG_PORT = 12345;
    private final AsynchronousSocketChannel client = AsynchronousSocketChannel.open();

    public DebuggerCore(String debugHost) throws InterruptedException, ExecutionException, IOException {
        InetSocketAddress hostAddress = new InetSocketAddress(debugHost, 12345);
        Future<Void> future = this.client.connect(hostAddress);
        future.get();
        System.out.println(this.readResponse());
    }

    private String readResponse() {
        ByteBuffer buffer = ByteBuffer.allocate(256);
        try {
            this.client.read(buffer).get();
        }
        catch (InterruptedException | ExecutionException e) {
            return null;
        }
        return new String(buffer.array()).trim();
    }

    private void writeRequest(String request) throws InterruptedException, ExecutionException {
        request = (String)request + "\r\n";
        ByteBuffer buffer = ByteBuffer.wrap(((String)request).getBytes());
        Future<Integer> write = this.client.write(buffer);
        write.get();
    }

    public long getGprRegister(DebuggerGprRegister gpr) throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_GET_GPR_REG;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt(), gpr.getInt()));
        String response = this.readResponse();
        if (response == null || response.isEmpty()) {
            return 0L;
        }
        Pattern gprPattern = Pattern.compile(cmd.getRecvFormat());
        Matcher gprMatcher = gprPattern.matcher(response);
        if (!gprMatcher.matches()) {
            return 0L;
        }
        long regValue = Long.parseLong(gprMatcher.group(3), 16) & 0xFFFFFFFFL;
        return regValue;
    }

    public long getPcRegister() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_GET_PC_REG;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        if (response == null || response.isEmpty()) {
            return 0L;
        }
        Pattern gprPattern = Pattern.compile(cmd.getRecvFormat());
        Matcher gprMatcher = gprPattern.matcher(response);
        if (!gprMatcher.matches()) {
            return 0L;
        }
        long regValue = Long.parseLong(gprMatcher.group(1), 16) & 0xFFFFFFFFL;
        return regValue;
    }

    public long[] getLoHiRegisters() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_GET_LO_HI_REGS;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        if (response == null || response.isEmpty()) {
            return new long[]{0L, 0L};
        }
        Pattern gprPattern = Pattern.compile(cmd.getRecvFormat());
        Matcher gprMatcher = gprPattern.matcher(response);
        if (!gprMatcher.matches()) {
            return new long[]{0L, 0L};
        }
        long loValue = Long.parseLong(gprMatcher.group(1), 16) & 0xFFFFFFFFL;
        long hiValue = Long.parseLong(gprMatcher.group(2), 16) & 0xFFFFFFFFL;
        return new long[]{loValue, hiValue};
    }

    public boolean stepInto() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_TRACE_EXECUTION;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        return response != null && !response.isEmpty();
    }

    public boolean stepOver() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_STEP_OVER;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        return response != null && !response.isEmpty();
    }

    public boolean runTo() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_RUN_TO;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        return response != null && !response.isEmpty();
    }

    public boolean pause() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_PAUSE_EXECUTION;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        return response != null && !response.isEmpty();
    }

    public boolean resume() throws InterruptedException, ExecutionException {
        DebuggerCmd cmd = DebuggerCmd.CMD_RESUME_EXECUTION;
        this.writeRequest(String.format(cmd.getSendFormat(), cmd.getInt()));
        String response = this.readResponse();
        return response != null && !response.isEmpty();
    }

    public void closeSocket() throws IOException {
        this.client.close();
    }

    @FunctionalInterface
    public static interface AcceptString {
        public void apply(String var1);
    }
}

