/*
 * Decompiled with CFR 0.152.
 */
package psx.debug;

import docking.WindowPosition;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import psx.PsxPlugin;
import psx.debug.DebuggerCore;
import psx.debug.DebuggerGprRegister;
import psx.debug.DebuggerGui;
import resources.ResourceManager;

public class DebuggerProvider
extends ComponentProviderAdapter {
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/debug_icon.png");
    private final DebuggerGui gui;
    private DebuggerCore core;
    private final Program program;

    public DebuggerProvider(PluginTool tool, String name, Program program) {
        super(tool, name, name);
        this.program = program;
        this.gui = new DebuggerGui();
        this.gui.initButtonsState();
        this.setBtnActions();
        this.setIcon(ICON);
        this.setDefaultWindowPosition(WindowPosition.RIGHT);
        this.setTitle("PSX Debugger");
        this.setVisible(true);
    }

    public void componentActivated() {
        super.componentActivated();
        this.updateAddressSpaces();
    }

    private void startDebugger() {
        try {
            this.core = new DebuggerCore("localhost");
            this.showRegisters();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            this.gui.initButtonsState();
            Msg.showError((Object)((Object)this), (Component)this.gui, (String)"Error", (Object)"Cannot connect to debugger server!", (Throwable)e);
        }
    }

    private void stopDebugger() {
        if (this.core == null) {
            return;
        }
        try {
            this.core.closeSocket();
        }
        catch (IOException e) {
            Msg.showError((Object)((Object)this), (Component)this.gui, (String)"Error", (Object)"Cannot close debugger connection!", (Throwable)e);
        }
    }

    private void showPcReg() {
        long pc = 0L;
        try {
            pc = this.core.getPcRegister();
            this.gui.setPcRegDisplay(pc);
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showError((Object)((Object)this), (Component)this.gui, (String)"Error", (Object)"Cannot get PC value!", (Throwable)e);
            return;
        }
        PsxPlugin.gotoPc(this.tool, this.program, this.gui.getAddressSpace(), pc);
    }

    private void showGprRegs() {
        if (this.core == null) {
            return;
        }
        DebuggerGprRegister[] regs = DebuggerGprRegister.values();
        for (int i = 0; i < regs.length; ++i) {
            long gprRegValue = 0L;
            try {
                gprRegValue = this.core.getGprRegister(regs[i]);
                this.gui.setGprRegDisplay(regs[i].getInt(), gprRegValue);
                continue;
            }
            catch (InterruptedException | ExecutionException e) {
                Msg.showWarn((Object)((Object)this), (Component)this.gui, (String)"Warning", (Object)String.format("Cannot get GPR:%s register!", regs[i].getName()));
                break;
            }
        }
    }

    private void showLoHiRegs() {
        long[] loHiValues = new long[]{0L, 0L};
        try {
            loHiValues = this.core.getLoHiRegisters();
            this.gui.setLoHiRegsDisplay(loHiValues[0], loHiValues[1]);
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showError((Object)((Object)this), (Component)this.gui, (String)"Error", (Object)"Cannot get LO/HI values!", (Throwable)e);
            return;
        }
    }

    private void showRegisters() {
        this.showPcReg();
        this.showGprRegs();
        this.showLoHiRegs();
    }

    private void stepInto() {
        if (this.core == null) {
            return;
        }
        try {
            if (!this.core.stepInto()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showWarn((Object)((Object)this), (Component)this.gui, (String)"Warning", (Object)"Cannot step into!");
        }
        this.showRegisters();
    }

    private void stepOver() {
        if (this.core == null) {
            return;
        }
        try {
            if (!this.core.stepOver()) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showWarn((Object)((Object)this), (Component)this.gui, (String)"Warning", (Object)"Cannot step over!");
        }
        this.showRegisters();
    }

    private void pause() {
        if (this.core == null) {
            return;
        }
        try {
            this.core.pause();
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showWarn((Object)((Object)this), (Component)this.gui, (String)"Warning", (Object)"Cannot pause!");
        }
        this.showRegisters();
    }

    private void resume() {
        if (this.core == null) {
            return;
        }
        try {
            this.core.resume();
        }
        catch (InterruptedException | ExecutionException e) {
            Msg.showWarn((Object)((Object)this), (Component)this.gui, (String)"Warning", (Object)"Cannot resume!");
        }
    }

    private void setBtnActions() {
        if (this.gui == null) {
            return;
        }
        this.gui.setStartDebuggerAction(a -> this.startDebugger());
        this.gui.setStopDebuggerAction(a -> this.stopDebugger());
        this.gui.setStepIntoAction(a -> this.stepInto());
        this.gui.setStepOverAction(a -> this.stepOver());
        this.gui.setPauseAction(a -> this.pause());
        this.gui.setRunAction(a -> this.resume());
    }

    private void updateAddressSpaces() {
        MemoryBlock[] memBlocks;
        ArrayList<String> overlays = new ArrayList<String>();
        for (MemoryBlock block : memBlocks = this.program.getMemory().getBlocks()) {
            if (!block.isOverlay()) continue;
            overlays.add(block.getName());
        }
        this.gui.updateAddressSpacesList((String[])overlays.toArray(String[]::new));
    }

    public void close() {
        this.stopDebugger();
    }

    public JComponent getComponent() {
        return this.gui;
    }
}

