/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import generic.stl.Pair;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MaskedBytes {
    private byte[] bytes;
    private byte[] masks;

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getMasks() {
        return this.masks;
    }

    public int getLength() {
        return this.bytes.length;
    }

    public MaskedBytes(byte[] bytes, byte[] masks) {
        this.bytes = bytes;
        this.masks = masks;
    }

    public List<Pair<String, Integer>> applyPatches(List<Pair<Integer, Pair<String, String>>> patches, List<Pair<String, Integer>> labels) throws IOException {
        if (patches == null || patches.isEmpty()) {
            return labels;
        }
        ArrayList<Pair<String, Integer>> newLabels = new ArrayList<Pair<String, Integer>>();
        newLabels.addAll(labels);
        int offsetDelta = 0;
        for (Pair<Integer, Pair<String, String>> patch : patches) {
            int i;
            int patchOff = offsetDelta + (Integer)patch.first;
            Pair patchData = (Pair)patch.second;
            MaskedBytes patchBytes = MaskedBytes.fromMaskedString(((String)patchData.first).substring(1));
            MaskedBytes patchCheckBytes = MaskedBytes.fromMaskedString((String)patchData.second);
            byte[] checkBytes = patchCheckBytes != null ? patchCheckBytes.getBytes() : null;
            long patchBytesLen = patchBytes != null ? (long)patchBytes.getLength() : 0L;
            long shift = 0L;
            switch (((String)patchData.first).charAt(0)) {
                case '~': {
                    i = 0;
                    while ((long)i < patchBytesLen) {
                        if (this.bytes[patchOff + i] != checkBytes[i]) {
                            throw new IOException(String.format("Wrong replace-patch data, OFF: %d, data: %s", patch.first, patchData.second));
                        }
                        this.bytes[patchOff + i] = patchBytes.bytes[i];
                        this.masks[patchOff + i] = patchBytes.masks[i];
                        ++i;
                    }
                    break;
                }
                case '+': {
                    MaskedBytes newData = MaskedBytes.expand(new MaskedBytes(this.bytes, this.masks), patchBytes, patchOff);
                    this.bytes = newData.getBytes();
                    this.masks = newData.getMasks();
                    shift = patchBytesLen;
                    offsetDelta = (int)((long)offsetDelta + patchBytesLen);
                    break;
                }
                case '-': {
                    int count = Integer.parseInt(((String)patchData.first).substring(1));
                    MaskedBytes newData = MaskedBytes.shrink(new MaskedBytes(this.bytes, this.masks), count, patchOff);
                    this.bytes = newData.getBytes();
                    this.masks = newData.getMasks();
                    shift = -count;
                    offsetDelta -= count;
                }
            }
            if (shift == 0L) continue;
            for (i = 0; i < labels.size(); ++i) {
                String lbName = (String)((Pair)newLabels.get((int)i)).first;
                int lbOffset = (Integer)((Pair)newLabels.get((int)i)).second;
                int oldOffset = (Integer)labels.get((int)i).second;
                if (shift < 0L && oldOffset >= (Integer)patch.first && (long)oldOffset < (long)((Integer)patch.first).intValue() + -1L * shift) {
                    lbName = "";
                }
                if (patchOff < lbOffset) {
                    lbOffset = (int)((long)lbOffset + shift);
                }
                newLabels.set(i, (Pair<String, Integer>)new Pair((Object)lbName, (Object)lbOffset));
            }
        }
        return newLabels;
    }

    private static MaskedBytes expand(MaskedBytes src, MaskedBytes add, int offset) {
        ByteArrayOutputStream newBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream newMasks = new ByteArrayOutputStream();
        try {
            newBytes.write(Arrays.copyOf(src.getBytes(), offset));
            newMasks.write(Arrays.copyOf(src.getMasks(), offset));
            newBytes.write(add.getBytes());
            newMasks.write(add.getMasks());
            newBytes.write(Arrays.copyOfRange(src.getBytes(), offset, src.getLength()));
            newMasks.write(Arrays.copyOfRange(src.getMasks(), offset, src.getLength()));
            return new MaskedBytes(newBytes.toByteArray(), newMasks.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static MaskedBytes shrink(MaskedBytes src, int length, int offset) {
        ByteArrayOutputStream newBytes = new ByteArrayOutputStream();
        ByteArrayOutputStream newMasks = new ByteArrayOutputStream();
        try {
            newBytes.write(Arrays.copyOf(src.getBytes(), offset));
            newMasks.write(Arrays.copyOf(src.getMasks(), offset));
            newBytes.write(Arrays.copyOfRange(src.getBytes(), offset + length, src.getLength()));
            newMasks.write(Arrays.copyOfRange(src.getMasks(), offset + length, src.getLength()));
            return new MaskedBytes(newBytes.toByteArray(), newMasks.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MaskedBytes fromMaskedString(String sig) {
        if (sig == null) {
            return null;
        }
        int len = sig.length();
        if (len % 3 != 0) {
            return null;
        }
        byte[] bytes = new byte[len / 3];
        byte[] masks = new byte[len / 3];
        for (int i = 0; i < len; i += 3) {
            char c1 = sig.charAt(i);
            char c2 = sig.charAt(i + 1);
            masks[i / 3] = (byte)((c1 == '?' ? 0 : 15) << 4 | (c2 == '?' ? 0 : 15));
            bytes[i / 3] = (byte)((c1 == '?' ? 0 : Character.digit(c1, 16)) << 4 | (c2 == '?' ? 0 : Character.digit(c2, 16)));
        }
        return new MaskedBytes(bytes, masks);
    }
}

