/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemIndexHelper;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryFull;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeFull;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@FileSystemInfo(type="psyqlibfile", description="PsyQ Library File", factory=PsyqFileSystemFactory.class)
public class PsyqLibFileSystem
implements GFileSystem {
    private final FSRLRoot fsFSRL;
    private FileSystemIndexHelper<LibFileItem> fsih;
    private FileSystemRefManager refManager = new FileSystemRefManager((GFileSystem)this);
    private ByteProvider provider;

    public PsyqLibFileSystem(FSRLRoot fsFSRL, ByteProvider provider) {
        this.fsFSRL = fsFSRL;
        this.provider = provider;
        this.fsih = new FileSystemIndexHelper((GFileSystem)this, fsFSRL);
    }

    public void mount(TaskMonitor monitor) {
        monitor.setMessage("Opening " + PsyqLibFileSystem.class.getSimpleName() + "...");
        monitor.clearCanceled();
        BinaryReader reader = new BinaryReader(this.provider, true);
        try {
            byte libVer = reader.readByte(3L);
            switch (libVer) {
                case 1: {
                    long startOffset;
                    long size;
                    for (startOffset = 4L; startOffset < reader.length() && !monitor.isCancelled(); startOffset += size) {
                        reader.setPointerIndex(startOffset);
                        String name = reader.readNextAsciiString(8);
                        long date = reader.readNextUnsignedInt();
                        Date dateTime = PsyqLibFileSystem.convertDosDate(date);
                        long offset = reader.readNextUnsignedInt();
                        size = reader.readNextUnsignedInt();
                        LibFileItem item = new LibFileItem();
                        item.name = name + ".OBJ";
                        item.date = dateTime;
                        item.offset = startOffset + offset;
                        item.size = size - offset;
                        this.fsih.storeFile(item.name, this.fsih.getFileCount(), false, item.size, (Object)item);
                    }
                    break;
                }
                case 2: {
                    long startOffset;
                    reader.setPointerIndex(startOffset);
                    long infoOff = reader.readNextUnsignedInt();
                    long infoLen = reader.readNextUnsignedInt();
                    reader.setPointerIndex(infoOff);
                    while (infoLen > 0L) {
                        long dataOffset = reader.readNextUnsignedInt();
                        infoLen -= 4L;
                        long dataSize = reader.readNextUnsignedInt();
                        infoLen -= 4L;
                        long date = reader.readNextUnsignedInt();
                        infoLen -= 4L;
                        byte nameLen = reader.readNextByte();
                        --infoLen;
                        nameLen = (byte)(nameLen + 1);
                        String name = reader.readNextAsciiString((int)nameLen);
                        infoLen -= (long)nameLen;
                        byte itemsCount = reader.readNextByte();
                        --infoLen;
                        Date dateTime = PsyqLibFileSystem.convertDosDate(date);
                        LibFileItem item = new LibFileItem();
                        item.name = name;
                        item.date = dateTime;
                        item.offset = dataOffset;
                        item.size = dataSize;
                        this.fsih.storeFile(item.name, this.fsih.getFileCount(), false, item.size, (Object)item);
                        while (itemsCount > 0) {
                            reader.readNextUnsignedShort();
                            infoLen -= 2L;
                            byte nameLen2 = reader.readNextByte();
                            --infoLen;
                            nameLen2 = (byte)(nameLen2 + 1);
                            reader.readNextAsciiString((int)nameLen2);
                            infoLen -= (long)nameLen2;
                            itemsCount = reader.readNextByte();
                            --infoLen;
                        }
                    }
                    break;
                }
            }
        }
        catch (IOException e) {
            return;
        }
    }

    private static Date convertDosDate(long date) {
        int tt = (int)(date >> 16) & 0xFFFF;
        int dd = (int)(date >> 0) & 0xFFFF;
        int year = (dd >> 9) + 1980;
        int month = dd >> 5 & 0xF;
        int day = dd & 0x1F;
        int hour = tt >> 11;
        int minute = tt >> 5 & 0x3F;
        int second = (tt & 0x1F) << 1;
        Calendar cl = Calendar.getInstance();
        cl.set(year, month, day, hour, minute, second);
        return cl.getTime();
    }

    public void close() throws IOException {
        this.refManager.onClose();
        if (this.provider != null) {
            this.provider.close();
            this.provider = null;
        }
        this.fsih.clear();
    }

    public String getName() {
        return this.fsFSRL.getContainer().getName();
    }

    public FSRLRoot getFSRL() {
        return this.fsFSRL;
    }

    public boolean isClosed() {
        return this.provider == null;
    }

    public int getFileCount() {
        return this.fsih.getFileCount();
    }

    public FileSystemRefManager getRefManager() {
        return this.refManager;
    }

    public GFile lookup(String path) throws IOException {
        return this.fsih.lookup(path);
    }

    public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        LibFileItem metadata = (LibFileItem)this.fsih.getMetadata(file);
        return metadata != null ? new ByteProviderInputStream(this.provider, metadata.offset, metadata.size) : null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return this.fsih.getListing(directory);
    }

    public String getInfo(GFile file, TaskMonitor monitor) {
        LibFileItem metadata = (LibFileItem)this.fsih.getMetadata(file);
        return metadata == null ? null : FSUtilities.infoMapToString(this.getInfoMap(metadata));
    }

    public Map<String, String> getInfoMap(LibFileItem metadata) {
        LinkedHashMap<String, String> info = new LinkedHashMap<String, String>();
        info.put("Name", metadata.name);
        info.put("Size", "0x" + Long.toHexString(metadata.size));
        info.put("Date", new SimpleDateFormat("dd-MM-yy HH:mm:ss").format(metadata.date));
        return info;
    }

    private static class LibFileItem {
        private String name;
        private Date date;
        private long offset;
        private long size;

        private LibFileItem() {
        }
    }

    public static class PsyqFileSystemFactory
    implements GFileSystemFactoryFull<PsyqLibFileSystem>,
    GFileSystemProbeFull {
        public PsyqLibFileSystem create(FSRL containerFSRL, FSRLRoot targetFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
            PsyqLibFileSystem fs = new PsyqLibFileSystem(targetFSRL, byteProvider);
            fs.mount(monitor);
            return fs;
        }

        public boolean probe(FSRL containerFSRL, ByteProvider byteProvider, File containerFile, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
            byte[] tag = byteProvider.readBytes(0L, 4L);
            return Arrays.equals(tag, new byte[]{76, 73, 66, 1}) || Arrays.equals(tag, new byte[]{76, 73, 66, 2});
        }
    }
}

