/*
 * Decompiled with CFR 0.152.
 */
package psyq;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import generic.stl.Pair;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import psyq.MaskedBytes;
import psyq.PsyqSig;

public final class SigApplier {
    private final List<PsyqSig> signatures;
    private final String shortLibName;
    private final String gameId;
    private final boolean onlyFirst;
    private final float minEntropy;

    public SigApplier(String gameId, String libJsonPath, String patchesFile, boolean onlyFirst, float minEntropy, TaskMonitor monitor) throws IOException {
        this.gameId = gameId.replace("_", "").replace(".", "");
        this.onlyFirst = onlyFirst;
        this.minEntropy = minEntropy;
        File libJsonFile = new File(libJsonPath);
        this.shortLibName = libJsonFile.getName().replace(".json", "");
        JsonArray root = SigApplier.jsonArrayFromFile(libJsonPath);
        JsonArray patches = SigApplier.jsonArrayFromFile(patchesFile);
        String psyLibVersion = libJsonFile.getParentFile().getName();
        JsonArray patchesObj = this.findGamePatches(patches, psyLibVersion);
        this.signatures = new ArrayList<PsyqSig>();
        for (JsonElement item : root) {
            JsonObject itemObj = item.getAsJsonObject();
            PsyqSig sig = PsyqSig.fromJsonToken(itemObj, patchesObj);
            this.signatures.add(sig);
        }
    }

    private static JsonArray jsonArrayFromFile(String file) throws IOException {
        if (file == null) {
            return null;
        }
        byte[] bytes = Files.readAllBytes(Path.of(file, new String[0]));
        String json = new String(bytes, "UTF8");
        JsonElement tokens = JsonParser.parseString((String)json);
        return tokens.getAsJsonArray();
    }

    private JsonArray findGamePatches(JsonArray patches, String version) {
        if (patches == null) {
            return null;
        }
        for (JsonElement patch : patches) {
            JsonObject patchObj = patch.getAsJsonObject();
            for (JsonElement game : patchObj.get("names").getAsJsonArray()) {
                String patchGameName = game.getAsString().replace("_", "").replace(".", "");
                if (!patchGameName.equalsIgnoreCase(this.gameId)) continue;
                JsonArray libs = patchObj.getAsJsonArray("libs");
                for (JsonElement lib : libs) {
                    JsonObject libObj = lib.getAsJsonObject();
                    String patchLibName = libObj.get("name").getAsString();
                    if (!patchLibName.equalsIgnoreCase(this.shortLibName)) continue;
                    JsonArray patchLibVersions = libObj.get("versions").getAsJsonArray();
                    for (JsonElement libVer : patchLibVersions) {
                        String patchLibVer = libVer.getAsString().replace(".", "");
                        if (!patchLibVer.equals(version)) continue;
                        return libObj.getAsJsonArray("objs");
                    }
                }
            }
        }
        return null;
    }

    public List<PsyqSig> getSignatures() {
        return this.signatures;
    }

    public void applySignatures(Program program, Address startAddr, Address endAddr, TaskMonitor monitor, MessageLog log) {
        FlatProgramAPI fpa = new FlatProgramAPI(program);
        Listing listing = program.getListing();
        int totalObjs = this.signatures.size();
        monitor.initialize((long)totalObjs);
        monitor.setMessage("Applying obj symbols...");
        monitor.clearCanceled();
        HashMap<String, Pair> objsList = new HashMap<String, Pair>();
        block0: for (PsyqSig psyqSig : this.signatures) {
            if (monitor.isCancelled()) break;
            boolean lowEntropy = psyqSig.getEntropy() < this.minEntropy;
            MaskedBytes bytes = psyqSig.getSig();
            List<Pair<String, Integer>> labels = psyqSig.getLabels();
            Address searchAddr = startAddr;
            while (!monitor.isCancelled() && searchAddr.compareTo((Object)endAddr) == -1) {
                Address addr = program.getMemory().findBytes(searchAddr, endAddr, bytes.getBytes(), bytes.getMasks(), true, monitor);
                if (addr == null) {
                    monitor.incrementProgress(1L);
                    continue block0;
                }
                if (!psyqSig.isApplied()) {
                    objsList.put(psyqSig.getName(), new Pair((Object)addr.getOffset(), (Object)Float.valueOf(psyqSig.getEntropy())));
                }
                for (Pair<String, Integer> lb : labels) {
                    String lbName = (String)lb.first;
                    int lbOffset = (Integer)lb.second;
                    if (lbName.isEmpty()) continue;
                    Address lbAddr = addr.add((long)lbOffset);
                    if (!(listing.getInstructionAt(lbAddr) != null || lowEntropy || psyqSig.isApplied() && this.onlyFirst)) {
                        DisassembleCommand disCmd = new DisassembleCommand((AddressSetView)new AddressSet(lbAddr), null);
                        disCmd.applyTo((DomainObject)program);
                    }
                    boolean isFunction = !lbName.startsWith("loc_");
                    String newName = String.format("%s_", psyqSig.getName().replace(".", "_"));
                    String newLbName = lbName.replace("text_", newName).replace("loc_", newName);
                    if (!(lowEntropy || psyqSig.isApplied() && this.onlyFirst || SigApplier.hasNonDefaultName(program, lbAddr, newLbName))) {
                        SigApplier.setFunction(program, fpa, lbAddr, newLbName, isFunction, false, log);
                        monitor.setMessage(String.format("Symbol %s at 0x%08X", newLbName, lbAddr.getOffset()));
                        continue;
                    }
                    String prevComment = listing.getComment(3, lbAddr);
                    String string = prevComment = prevComment != null ? String.format("%s\n", prevComment) : "";
                    String newComment = String.format("Possible %s/%s", psyqSig.getName(), newLbName);
                    if (prevComment.indexOf(newComment) != -1) continue;
                    listing.setComment(lbAddr, 3, String.format("%s%s", prevComment, newComment));
                    monitor.setMessage(String.format("Possible symbol %s at 0x%08X", newLbName, lbAddr.getOffset()));
                }
                psyqSig.setApplied(true);
                searchAddr = addr.add(4L);
                monitor.incrementProgress(1L);
            }
        }
        if (objsList.size() > 0) {
            log.appendMsg(String.format("Applied OBJs for %s: %d/%d:", this.shortLibName, objsList.size(), totalObjs));
            for (Map.Entry entry : objsList.entrySet()) {
                Pair val = (Pair)entry.getValue();
                log.appendMsg(String.format("\t0x%08X: %s, %.02f entropy", val.first, entry.getKey(), val.second));
            }
        }
    }

    private static void disasmInstruction(Program program, Address address) {
        DisassembleCommand cmd = new DisassembleCommand(address, null, true);
        cmd.applyTo((DomainObject)program, TaskMonitor.DUMMY);
    }

    public static void setFunction(Program program, FlatProgramAPI fpa, Address address, String name, boolean isFunction, boolean isEntryPoint, MessageLog log) {
        try {
            if (fpa.getInstructionAt(address) == null) {
                SigApplier.disasmInstruction(program, address);
            }
            if (isFunction) {
                fpa.createFunction(address, name);
            }
            if (isEntryPoint) {
                fpa.addEntryPoint(address);
            }
            if (isFunction && SigApplier.hasNonDefaultName(program, address, null)) {
                return;
            }
            program.getSymbolTable().createLabel(address, name, SourceType.IMPORTED);
        }
        catch (InvalidInputException e) {
            log.appendException((Throwable)e);
            e.printStackTrace();
        }
    }

    private static boolean hasNonDefaultName(Program program, Address address, String name) {
        Symbol[] existing = program.getSymbolTable().getSymbols(address);
        if (existing.length > 0) {
            for (Symbol sym : existing) {
                if (sym.getSource() != SourceType.USER_DEFINED && sym.getSource() != SourceType.IMPORTED) continue;
                return name == null ? true : !sym.getName().equals(name);
            }
        }
        return false;
    }
}

