/*
 * Decompiled with CFR 0.152.
 */
package psx;

import docking.DialogComponentProvider;
import docking.widgets.OptionDialog;
import ghidra.app.cmd.memory.AddInitializedMemoryBlockCmd;
import ghidra.app.util.AddressInput;
import ghidra.framework.model.DomainObject;
import ghidra.framework.store.LockException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.MessageType;
import ghidra.util.Msg;
import ghidra.util.NamingUtilities;
import ghidra.util.exception.NotFoundException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import psx.PsxLoader;

public class OverlayManager
extends JPanel {
    private final JLabel lblBlockName;
    private final JTextField blockName;
    private final JButton btnNewBlock;
    private final JLabel lblBlockStart;
    private final AddressInput blockStart;
    private final DialogComponentProvider provider;
    private final Memory memory;
    private final Program program;
    private final JRadioButton chkNewBlock;
    private final JRadioButton chkFillBlock;
    private final JPanel pnlNewBlock;
    private final JComboBox<String> overlaysList;
    private final JButton btnFillBlock;
    private Map<Integer, String> overlays = new HashMap<Integer, String>();
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton chkDeleteBlock;
    private JButton btnDeleteBlock;

    public OverlayManager(Program program, DialogComponentProvider provider) {
        this.provider = provider;
        this.program = program;
        this.memory = program.getMemory();
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{81, 110, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.chkNewBlock = new JRadioButton("New Block");
        this.buttonGroup.add(this.chkNewBlock);
        GridBagConstraints gbc_createNewBlock = new GridBagConstraints();
        gbc_createNewBlock.anchor = 18;
        gbc_createNewBlock.insets = new Insets(0, 0, 5, 5);
        gbc_createNewBlock.gridx = 0;
        gbc_createNewBlock.gridy = 0;
        this.add((Component)this.chkNewBlock, gbc_createNewBlock);
        this.chkFillBlock = new JRadioButton("Fill Block");
        GridBagConstraints gbc_chkFillBlock = new GridBagConstraints();
        gbc_chkFillBlock.anchor = 17;
        gbc_chkFillBlock.insets = new Insets(0, 0, 5, 5);
        gbc_chkFillBlock.gridx = 1;
        gbc_chkFillBlock.gridy = 0;
        this.add((Component)this.chkFillBlock, gbc_chkFillBlock);
        this.buttonGroup.add(this.chkFillBlock);
        this.chkDeleteBlock = new JRadioButton("Delete Block");
        GridBagConstraints gbc_chkDeleteBlock = new GridBagConstraints();
        gbc_chkDeleteBlock.anchor = 17;
        gbc_chkDeleteBlock.insets = new Insets(0, 0, 5, 0);
        gbc_chkDeleteBlock.gridx = 2;
        gbc_chkDeleteBlock.gridy = 0;
        this.add((Component)this.chkDeleteBlock, gbc_chkDeleteBlock);
        this.buttonGroup.add(this.chkDeleteBlock);
        this.pnlNewBlock = new JPanel();
        GridBagConstraints gbc_pnlNewBlock = new GridBagConstraints();
        gbc_pnlNewBlock.insets = new Insets(0, 0, 5, 0);
        gbc_pnlNewBlock.fill = 2;
        gbc_pnlNewBlock.gridwidth = 3;
        gbc_pnlNewBlock.anchor = 11;
        gbc_pnlNewBlock.gridx = 0;
        gbc_pnlNewBlock.gridy = 1;
        this.add((Component)this.pnlNewBlock, gbc_pnlNewBlock);
        GridBagLayout gbl_pnlNewBlock = new GridBagLayout();
        gbl_pnlNewBlock.columnWidths = new int[]{72, 88, 0, 0, 0};
        gbl_pnlNewBlock.rowHeights = new int[]{0, 0, 0};
        gbl_pnlNewBlock.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        gbl_pnlNewBlock.rowWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        this.pnlNewBlock.setLayout(gbl_pnlNewBlock);
        this.lblBlockName = new JLabel("Block Name:");
        GridBagConstraints gbc_lblBlockName = new GridBagConstraints();
        gbc_lblBlockName.anchor = 13;
        gbc_lblBlockName.insets = new Insets(0, 0, 5, 5);
        gbc_lblBlockName.gridx = 0;
        gbc_lblBlockName.gridy = 0;
        this.pnlNewBlock.add((Component)this.lblBlockName, gbc_lblBlockName);
        this.lblBlockName.setHorizontalAlignment(4);
        this.blockName = new JTextField("OVR1");
        GridBagConstraints gbc_blockName = new GridBagConstraints();
        gbc_blockName.fill = 2;
        gbc_blockName.insets = new Insets(0, 0, 5, 5);
        gbc_blockName.gridx = 1;
        gbc_blockName.gridy = 0;
        this.pnlNewBlock.add((Component)this.blockName, gbc_blockName);
        this.blockName.setColumns(10);
        this.lblBlockName.setLabelFor(this.blockName);
        this.lblBlockStart = new JLabel("Start Address:");
        GridBagConstraints gbc_lblBlockStart = new GridBagConstraints();
        gbc_lblBlockStart.anchor = 13;
        gbc_lblBlockStart.insets = new Insets(0, 0, 5, 5);
        gbc_lblBlockStart.gridx = 2;
        gbc_lblBlockStart.gridy = 0;
        this.pnlNewBlock.add((Component)this.lblBlockStart, gbc_lblBlockStart);
        this.lblBlockStart.setHorizontalAlignment(4);
        this.blockStart = new AddressInput();
        GridBagConstraints gbc_blockStart = new GridBagConstraints();
        gbc_blockStart.fill = 2;
        gbc_blockStart.insets = new Insets(0, 0, 5, 0);
        gbc_blockStart.gridx = 3;
        gbc_blockStart.gridy = 0;
        this.pnlNewBlock.add((Component)this.blockStart, gbc_blockStart);
        this.overlaysList = new JComboBox();
        GridBagConstraints gbc_overlaysList = new GridBagConstraints();
        gbc_overlaysList.insets = new Insets(0, 0, 5, 0);
        gbc_overlaysList.fill = 2;
        gbc_overlaysList.gridwidth = 3;
        gbc_overlaysList.gridx = 0;
        gbc_overlaysList.gridy = 2;
        this.add(this.overlaysList, gbc_overlaysList);
        this.btnNewBlock = new JButton("Create from a binary...");
        GridBagConstraints gbc_btnNewBlock = new GridBagConstraints();
        gbc_btnNewBlock.fill = 2;
        gbc_btnNewBlock.insets = new Insets(0, 0, 0, 5);
        gbc_btnNewBlock.gridx = 0;
        gbc_btnNewBlock.gridy = 3;
        this.add((Component)this.btnNewBlock, gbc_btnNewBlock);
        this.btnFillBlock = new JButton("Fill with a binary...");
        GridBagConstraints gbc_btnFillBlock = new GridBagConstraints();
        gbc_btnFillBlock.insets = new Insets(0, 0, 0, 5);
        gbc_btnFillBlock.gridx = 1;
        gbc_btnFillBlock.gridy = 3;
        this.add((Component)this.btnFillBlock, gbc_btnFillBlock);
        this.btnDeleteBlock = new JButton("Delete block");
        GridBagConstraints gbc_btnDeleteBlock = new GridBagConstraints();
        gbc_btnDeleteBlock.gridx = 2;
        gbc_btnDeleteBlock.gridy = 3;
        this.add((Component)this.btnDeleteBlock, gbc_btnDeleteBlock);
        AddressFactory addrFactory = program.getAddressFactory();
        this.blockStart.setAddressFactory(addrFactory, true, false);
        this.blockStart.setAddress(program.getImageBase());
        this.blockStart.addChangeListener(ev -> this.checkNameAndAddress());
        this.chkNewBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlayManager.this.setEnabledDeleteBlock(false);
                OverlayManager.this.setEnabledFillBlock(false);
                OverlayManager.this.setEnabledNewBlock(true);
                OverlayManager.this.checkNameAndAddress();
            }
        });
        this.chkFillBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlayManager.this.setEnabledNewBlock(false);
                OverlayManager.this.setEnabledDeleteBlock(false);
                OverlayManager.this.setEnabledFillBlock(true);
                OverlayManager.this.refreshBlocks();
            }
        });
        this.chkDeleteBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OverlayManager.this.setEnabledNewBlock(false);
                OverlayManager.this.setEnabledFillBlock(false);
                OverlayManager.this.setEnabledDeleteBlock(true);
                OverlayManager.this.refreshBlocks();
            }
        });
        this.setBlockNameListener();
        this.setNewBlockListener();
        this.setFillBlockListener();
        this.setDeleteBlockListener();
        this.chkNewBlock.doClick();
        this.setMinimumSize(new Dimension(130, 50));
    }

    private void setEnabledNewBlock(boolean enabled) {
        this.lblBlockName.setEnabled(enabled);
        this.blockName.setEnabled(enabled);
        this.lblBlockStart.setEnabled(enabled);
        this.blockStart.setEnabled(enabled);
        this.btnNewBlock.setEnabled(enabled);
    }

    private void refreshOverlaysList() {
        this.refreshBlocks();
        this.overlaysList.setSelectedIndex(this.overlays.size() > 0 ? 0 : -1);
    }

    private void setEnabledFillBlock(boolean enabled) {
        this.refreshOverlaysList();
        this.btnFillBlock.setEnabled(this.overlays.size() > 0);
        this.overlaysList.setEnabled(enabled);
        this.btnFillBlock.setEnabled(enabled);
        this.provider.clearStatusText();
    }

    private void setEnabledDeleteBlock(boolean enabled) {
        this.refreshOverlaysList();
        this.overlaysList.setEnabled(enabled);
        this.btnDeleteBlock.setEnabled(enabled);
        this.provider.clearStatusText();
    }

    private void refreshBlocks() {
        MemoryBlock[] memBlocks;
        this.overlaysList.removeAllItems();
        this.overlays.clear();
        for (MemoryBlock block : memBlocks = this.memory.getBlocks()) {
            if (!block.isOverlay()) continue;
            this.overlays.put(this.overlays.size(), block.getName());
            this.overlaysList.addItem(String.format("%s: 0x%08X-0x%08X", block.getName(), block.getStart().getOffset(), block.getEnd().getOffset()));
        }
    }

    private void checkNameAndAddress() {
        this.btnNewBlock.setEnabled(this.nameChanged() && this.addressChanged());
    }

    private boolean addressChanged() {
        this.btnNewBlock.setEnabled(false);
        Address addr = null;
        try {
            addr = this.blockStart.getAddress();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (addr == null) {
            this.provider.setStatusText("Please enter a valid starting address", MessageType.ERROR);
            return false;
        }
        if (addr.getOffset() < PsxLoader.ramBase || addr.getOffset() >= PsxLoader.ramBase + 0x200000L) {
            this.provider.setStatusText(String.format("An address must be in range: %08X-%08X", PsxLoader.ramBase, PsxLoader.ramBase + 0x200000L - 1L));
            return false;
        }
        this.blockStart.setAddress(addr);
        this.provider.clearStatusText();
        return true;
    }

    private boolean nameChanged() {
        String name = this.blockName.getText().trim();
        if (name.isEmpty()) {
            this.provider.setStatusText("Please enter a name!");
            return false;
        }
        if (!NamingUtilities.isValidProjectName((String)name)) {
            this.provider.setStatusText("Invalid block name!", MessageType.ERROR);
            return false;
        }
        if (this.memory.getBlock(name) != null) {
            this.provider.setStatusText("Block name already exists!", MessageType.ERROR);
            return false;
        }
        this.provider.clearStatusText();
        return true;
    }

    private void setBlockNameListener() {
        this.blockName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                OverlayManager.this.checkNameAndAddress();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OverlayManager.this.checkNameAndAddress();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                OverlayManager.this.checkNameAndAddress();
            }
        });
    }

    private void setNewBlockListener() {
        final JFileChooser jfc = new JFileChooser(this.program.getExecutablePath());
        jfc.setDialogTitle("Please, select overlay file...");
        jfc.setMultiSelectionEnabled(false);
        this.btnNewBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jfc.showOpenDialog(OverlayManager.this) != 0) {
                    return;
                }
                try {
                    String filePath = jfc.getSelectedFile().getAbsolutePath();
                    FileInputStream fis = new FileInputStream(filePath);
                    byte[] fileData = fis.readAllBytes();
                    fis.close();
                    Memory mem = OverlayManager.this.program.getMemory();
                    int tranId = OverlayManager.this.program.startTransaction(String.format("Creating overlayed block %s from a binary", OverlayManager.this.blockName.getText()));
                    AddInitializedMemoryBlockCmd cmd = new AddInitializedMemoryBlockCmd(OverlayManager.this.blockName.getText(), null, filePath, OverlayManager.this.blockStart.getAddress(), (long)fileData.length, true, true, true, false, 0, true);
                    cmd.applyTo((DomainObject)OverlayManager.this.program);
                    MemoryBlock block = mem.getBlock(OverlayManager.this.blockName.getText());
                    mem.setBytes(block.getStart(), fileData);
                    OverlayManager.this.program.endTransaction(tranId, true);
                    OverlayManager.this.refreshBlocks();
                    OverlayManager.this.checkNameAndAddress();
                    Msg.showInfo((Object)this, (Component)OverlayManager.this, (String)"Information", (Object)"Overlay block has been created!");
                }
                catch (IOException e1) {
                    Msg.showError((Object)this, (Component)OverlayManager.this, (String)"Error", (Object)"Cannot read overlay file!", (Throwable)e1);
                }
                catch (MemoryAccessException e1) {
                    Msg.showError((Object)this, (Component)OverlayManager.this, (String)"Error", (Object)"Cannot set block data!", (Throwable)e1);
                }
            }
        });
    }

    private void setFillBlockListener() {
        final JFileChooser jfc = new JFileChooser(this.program.getExecutablePath());
        jfc.setDialogTitle("Please, select overlay file...");
        jfc.setMultiSelectionEnabled(false);
        this.btnFillBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (jfc.showOpenDialog(OverlayManager.this) != 0) {
                    return;
                }
                try {
                    FileInputStream fis = new FileInputStream(jfc.getSelectedFile().getAbsolutePath());
                    byte[] fileData = fis.readAllBytes();
                    fis.close();
                    int index = OverlayManager.this.overlaysList.getSelectedIndex();
                    MemoryBlock block = OverlayManager.this.memory.getBlock(OverlayManager.this.overlays.get(index));
                    int transId = OverlayManager.this.program.startTransaction(String.format("Applying overlayed binary to %s", block.getName()));
                    if (block.isInitialized()) {
                        OverlayManager.this.memory.convertToUninitialized(block);
                    }
                    OverlayManager.this.memory.convertToInitialized(block, (byte)0);
                    OverlayManager.this.memory.setBytes(block.getStart(), fileData);
                    OverlayManager.this.program.endTransaction(transId, true);
                    OverlayManager.this.refreshBlocks();
                    Msg.showInfo((Object)this, (Component)OverlayManager.this, (String)"Information", (Object)"Overlay data has been applied!");
                }
                catch (IOException e1) {
                    Msg.showError((Object)this, (Component)OverlayManager.this, (String)"Error", (Object)"Cannot read overlay file!", (Throwable)e1);
                }
                catch (LockException | MemoryAccessException | NotFoundException e2) {
                    Msg.showError((Object)this, (Component)OverlayManager.this, (String)"Error", (Object)"Cannot set overlay block data!", (Throwable)e2);
                }
            }
        });
    }

    private void setDeleteBlockListener() {
        this.btnDeleteBlock.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = OverlayManager.this.overlaysList.getSelectedIndex();
                MemoryBlock block = OverlayManager.this.memory.getBlock(OverlayManager.this.overlays.get(index));
                if (1 == OptionDialog.showYesNoDialogWithNoAsDefaultButton(null, (String)"Question", (String)String.format("Are you sure you want to delete %s block?", block.getName()))) {
                    try {
                        int transId = OverlayManager.this.program.startTransaction(String.format("Removing block %s", block.getName()));
                        OverlayManager.this.memory.removeBlock(block, TaskMonitor.DUMMY);
                        OverlayManager.this.program.endTransaction(transId, true);
                        OverlayManager.this.refreshBlocks();
                        Msg.showInfo((Object)this, (Component)OverlayManager.this, (String)"Information", (Object)"Overlay block has been deleted!");
                    }
                    catch (LockException e1) {
                        Msg.showError((Object)this, (Component)OverlayManager.this, (String)"Error", (Object)"Cannot remove memory block!", (Throwable)e1);
                    }
                }
            }
        });
    }
}

