# ghidra_psx_ldr
Sony Playstation PSX executables loader for GHIDRA

Video tutorial on how to deal with overlays: https://youtu.be/DuQQfjTkkQc

# Building
* Make sure [Gradle is installed](https://gradle.org/install/) in your system.
* Clone the ghidra_psx_ldr repository to a local directory in your computer.
* In your local ghidra_psx_ldr directory, set the GHIDRA_INSTALL_DIR environment variable and run Gradle:
    * **\*nix**: `env GHIDRA_INSTALL_DIR=/PATHTOYOURGHIDRAINSTALLATION gradle buildExtension`
    * **Windows**: `cmd /C "set "GHIDRA_INSTALL_DIR=PATHTOYOURGHIDRAINSTALLATION" && gradle buildExtension"`

    This will build the project, generating a .zip file in the newly created dist directory for use with your Ghidra installation.
    
# Installation
* Open Ghidra, go to File -> Install Extensions... and select the .zip file generated by the previous step.

# Patches format ([example here](https://github.com/lab313ru/ghidra_psx_ldr/blob/master/data/psyq/patches.json))

* `~` - is for replacing some pattern in a signature. check field is the original bytes in the signature to compare with
* `+` - is for adding some pattern in a signature
* `-` - is for removing some pattern from a signature

! `pos` fields are for the original signature. you should not add appended or removed sizes to them

# Screenshots

![Screen1](/imgs/screen1.png?raw=true)
![Screen7](/imgs/screen7.png?raw=true)
![Screen4](/imgs/screen4.png?raw=true)
![Screen5](/imgs/screen5.png?raw=true)
![Screen6](/imgs/screen6.png?raw=true)

